
#ifndef _INFRARED_H_
#define _INFRARED_H_

#include "types.h"

#define IR_NOCODE 0x00000000L
#define IR_REPEAT 0x00800000L
#define IR_CODE(x) ((x)&0xFF7FFFFFL)
#define IR_RC5 0x00010000L
#define IR_NEC 0x00020000L
#define RC5(x) ((x)|IR_RC5)
#define NEC(x) ((x)|IR_NEC)

// codes for Altronics A1012 ("DynaLink") remote control on "TV" setting 156
#define RC5_A1012_STANDBY	0x008C
#define RC5_A1012_MUTE		0x008D

#define RC5_A1012_1			0x0081
#define RC5_A1012_2			0x0082
#define RC5_A1012_3			0x0083
#define RC5_A1012_4			0x0084
#define RC5_A1012_5			0x0085
#define RC5_A1012_6			0x0086
#define RC5_A1012_7			0x0087
#define RC5_A1012_8			0x0088
#define RC5_A1012_9			0x0089
#define RC5_A1012_0			0x0080

#define RC5_A1012_CHUP		0x008A
#define RC5_A1012_CHDN		0x008B
#define RC5_A1012_VOLUP		0x0090
#define RC5_A1012_VOLDN		0x0091

#define RC5_A1012_UP		0x0092
#define RC5_A1012_DOWN		0x0093
#define RC5_A1012_LEFT		0x0095
#define RC5_A1012_RIGHT		0x0094
#define RC5_A1012_OK		0x00A3

#define RC5_A1012_TELETEXT	0x00BF
#define RC5_A1012_PAGEHOLD	0x00A9
#define RC5_A1012_TVVIDEO	0x00AD
#define RC5_A1012_OSD		0x00BE
#define RC5_A1012_RECORD	0x00AE
#define RC5_A1012_PAUSE		0x00B5
#define RC5_A1012_EXIT      0x008B
#define RC5_A1012_RW        0x00B7
#define RC5_A1012_PLAY      0x00B2
#define RC5_A1012_FF        0x00B4
#define RC5_A1012_STOP      0x00B6


// codes for Jaycar AR1726 Digitech Universal remote on "TV" setting 102
#define RC5_AR1726_MUTE     0x000D
#define RC5_AR1726_STANDBY  0x000C

#define RC5_AR1726_1        0x0001
#define RC5_AR1726_2        0x0002
#define RC5_AR1726_3        0x0003
#define RC5_AR1726_4        0x0004
#define RC5_AR1726_5        0x0005
#define RC5_AR1726_6        0x0006
#define RC5_AR1726_7        0x0007
#define RC5_AR1726_8        0x0008
#define RC5_AR1726_9        0x0009
#define RC5_AR1726_1_       0x000A
#define RC5_AR1726_0        0x0000
#define RC5_AR1726_2_       0x000B

#define RC5_AR1726_UP       0x0014
#define RC5_AR1726_DOWN     0x0015
#define RC5_AR1726_LEFT     0x0013
#define RC5_AR1726_RIGHT    0x0012
#define RC5_AR1726_OK       0x002F

#define RC5_AR1726_CHUP     0x0020
#define RC5_AR1726_CHDN     0x0021
#define RC5_AR1726_VOLUP    0x0010
#define RC5_AR1726_VOLDN    0x0011
#define RC5_AR1726_MENU     0x003B

#define RC5_AR1726_TV_VCR   0x003F
#define RC5_AR1726_RECORD   0x003C
#define RC5_AR1726_TV_AC    0x0038
#define RC5_AR1726_STOP     0x002C
#define RC5_AR1726_PLAY     0x002B
#define RC5_AR1726_PAUSE    0x0035
#define RC5_AR1726_RW       0x002E
#define RC5_AR1726_REPLAY   0x0029
#define RC5_AR1726_FF       0x002A

// codes for Digitech Audio remote on default TV setting
#define NEC_0    	  0x0058
#define NEC_1    	  0x0088
#define NEC_2    	  0x0048
#define NEC_3		  0x00C8
#define NEC_4		  0x0028
#define NEC_5		  0x00A8
#define NEC_6		  0x0068
#define NEC_7		  0x00E8
#define NEC_8		  0x0018
#define NEC_9		  0x0098
#define NEC_STANDBY	  0x00C0
#define NEC_MUTE	  0x0080
#define NEC_VOLUP	  0x00B8
#define NEC_VOLDN	  0x0050
#define NEC_MODEUP	  0x00F8
#define NEC_MODEDN	  0x0030
#define NEC_RIGHT	  0x00E0
#define NEC_LEFT	  0x00A0
#define NEC_UP		  0x0020
#define NEC_DOWN	  0x0090

// codes for Altronics A1012 ("DynaLink") remote control on "VCR" setting 115
#define RC5_A1012_VCR_MUTE		0x016D

#define RC5_A1012_VCR_1			0x0141
#define RC5_A1012_VCR_2			0x0142
#define RC5_A1012_VCR_3			0x0143
#define RC5_A1012_VCR_4			0x0144
#define RC5_A1012_VCR_5			0x0145
#define RC5_A1012_VCR_6			0x0146
#define RC5_A1012_VCR_7			0x0147
#define RC5_A1012_VCR_8			0x0148
#define RC5_A1012_VCR_9			0x0149
#define RC5_A1012_VCR_0			0x0140

#define RC5_A1012_VCR_CHUP		0x0160
#define RC5_A1012_VCR_CHDN		0x0161
#define RC5_A1012_VCR_VOLUP		0x0150
#define RC5_A1012_VCR_VOLDN		0x0151

// codes for Jaycar AR1726 Digitech Universal remote on "VCR" setting 916
#define RC5_AR1726_VCR_MUTE     0x014D

#define RC5_AR1726_VCR_1        0x0141
#define RC5_AR1726_VCR_2        0x0142
#define RC5_AR1726_VCR_3        0x0143
#define RC5_AR1726_VCR_4        0x0144
#define RC5_AR1726_VCR_5        0x0145
#define RC5_AR1726_VCR_6        0x0146
#define RC5_AR1726_VCR_7        0x0147
#define RC5_AR1726_VCR_8        0x0148
#define RC5_AR1726_VCR_9        0x0149
#define RC5_AR1726_VCR_0        0x0140

#define RC5_AR1726_VCR_CHUP     0x0160
#define RC5_AR1726_VCR_CHDN     0x0161
#define RC5_AR1726_VCR_VOLUP    0x0150
#define RC5_AR1726_VCR_VOLDN    0x0151

// codes for Jaycar AR1723 Digitech Universal remote on code setting 0348 (Technotrend Satellite TV receiver)

#define RC5_AR1723_0348_MUTE     0x0542
#define RC5_AR1723_0348_STANDBY  0x0541

#define RC5_AR1723_0348_1         0x0543
#define RC5_AR1723_0348_2         0x0544
#define RC5_AR1723_0348_3         0x0545
#define RC5_AR1723_0348_4         0x0546
#define RC5_AR1723_0348_5         0x0547
#define RC5_AR1723_0348_6         0x0548
#define RC5_AR1723_0348_7         0x0549
#define RC5_AR1723_0348_8         0x054A
#define RC5_AR1723_0348_9         0x054B
#define RC5_AR1723_0348_1_        0x0562
#define RC5_AR1723_0348_0         0x054C
#define RC5_AR1723_0348_AV        0x055A

#define RC5_AR1723_0348_UP        0x054D
#define RC5_AR1723_0348_DOWN      0x0551
#define RC5_AR1723_0348_LEFT      0x054E
#define RC5_AR1723_0348_RIGHT     0x0550
#define RC5_AR1723_0348_OK        0x054F

#define RC5_AR1723_0348_CHUP      0x0563
#define RC5_AR1723_0348_CHDN      0x0564
#define RC5_AR1723_0348_VOLUP     0x0565
#define RC5_AR1723_0348_VOLDN     0x0566
#define RC5_AR1723_0348_MENU      0x0558

#define RC5_AR1723_0348_INFO      0x0567
#define RC5_AR1723_0348_BACK      0x057C
#define RC5_AR1723_0348_EPG       0x0561

#define RC5_AR1723_0348_SQUARE    0x056B
#define RC5_AR1723_0348_LINES     0x0559
#define RC5_AR1723_0348_LETTERBOX 0x0562
//#define RC5_AR1723_0348_SKEW

#define RC5_AR1723_0348_RED       0x057A
#define RC5_AR1723_0348_GREEN     0x057D
#define RC5_AR1723_0348_YELLOW    0x057B
#define RC5_AR1723_0348_BLUE      0x057F


void Infrared_Setup();

extern volatile unsigned long ir_final_code;
extern void (*ir_cn_interrupt_chain)(void);

#endif//_INFRARED_H_
